package com.ElyStudio.leGaou.adapter;

import android.content.Context;
import android.content.Intent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;

import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;

import com.google.android.material.card.MaterialCardView;
import com.ElyStudio.leGaou.R;
import com.ElyStudio.leGaou.activities.AllQuizActivity;
import com.ElyStudio.leGaou.models.Category;
import com.ElyStudio.leGaou.utilities.Constants;
import com.squareup.picasso.Picasso;

import java.util.List;

public class CategoryAdapter extends RecyclerView.Adapter<CategoryAdapter.CategoryViewHolder> {

    private Context context;
    private List<Category> categoryList;
    private int adEnabled;
    private int userCoins;
    private int watchEarnReward;
    private String nativeAdId,interstitialAdId, rewardedAdId;

    public CategoryAdapter(Context context, List<Category> categoryList, int adEnabled, int userCoins, int watchEarnReward, String nativeAdId, String interstitialAdId, String rewardedAdId) {
        this.context = context;
        this.categoryList = categoryList;
        this.adEnabled = adEnabled;
        this.userCoins = userCoins;
        this.watchEarnReward = watchEarnReward;
        this.nativeAdId = nativeAdId;
        this.interstitialAdId = interstitialAdId;
        this.rewardedAdId = rewardedAdId;
    }

    @NonNull
    @Override
    public CategoryAdapter.CategoryViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new CategoryViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.category_card_layout,parent,false));
    }

    @Override
    public void onBindViewHolder(@NonNull CategoryAdapter.CategoryViewHolder holder, int position) {
        Category category = categoryList.get(position);
        int categoryCardColor;
        int colorCode = category.getColorCode();
        if(colorCode ==  1)
        {
            categoryCardColor = context.getResources().getColor(R.color.quiz_color_bg_1);
        }
        else if(colorCode == 2)
        {
            categoryCardColor = context.getResources().getColor(R.color.quiz_color_bg_2);
        }
        else if(colorCode == 3)
        {
            categoryCardColor = context.getResources().getColor(R.color.quiz_color_bg_3);
        }
        else if(colorCode == 4)
        {
            categoryCardColor = context.getResources().getColor(R.color.quiz_color_bg_4);
        }
        else if(colorCode == 5)
        {
            categoryCardColor = context.getResources().getColor(R.color.quiz_color_bg_5);
        }
        else if(colorCode == 6)
        {
            categoryCardColor = context.getResources().getColor(R.color.quiz_color_bg_6);
        }
        else if(colorCode == 7)
        {
            categoryCardColor = context.getResources().getColor(R.color.quiz_color_bg_7);
        }
        else if(colorCode == 8)
        {
            categoryCardColor = context.getResources().getColor(R.color.quiz_color_bg_8);
        }
        else {
            categoryCardColor = context.getResources().getColor(R.color.quiz_color_bg_default);
        }
        holder.categoryCard.setCardBackgroundColor(categoryCardColor);

        if(!category.getIcon().trim().isEmpty())
        {
            Picasso.get().load(Constants.ADMIN_PANEL_URL +category.getIcon()).into(holder.categoryIcon);
        }
        else
        {
            holder.categoryIcon.setImageDrawable(ContextCompat.getDrawable(context,R.drawable.image_placeholder));
        }

        holder.categoryCard.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent intent = new Intent(context, AllQuizActivity.class);
                intent.putExtra(Constants.categoryId,category.getId());
                intent.putExtra(Constants.categoryTitle,category.getName());
                intent.putExtra(Constants.adEnabled,adEnabled);
                intent.putExtra(Constants.watchEarnReward,watchEarnReward);
                intent.putExtra(Constants.nativeAdId,nativeAdId);
                intent.putExtra(Constants.interstitialAdId,interstitialAdId);
                intent.putExtra(Constants.rewardedAdId,rewardedAdId);
                context.startActivity(intent);
            }
        });
    }

    @Override
    public int getItemCount() {
        return categoryList.size();
    }

    public class CategoryViewHolder extends RecyclerView.ViewHolder {
        MaterialCardView categoryCard;
        ImageView categoryIcon;
        public CategoryViewHolder(@NonNull View itemView) {
            super(itemView);

            categoryCard = itemView.findViewById(R.id.categoryCard);
            categoryIcon = itemView.findViewById(R.id.categoryIcon);

        }
    }
}
